import type { Timestamp } from 'firebase/firestore';

export interface Addon {
  id: string;
  name: string;
  price: number;
}

export interface Product {
  id: string;
  name: string;
  description: string;
  price: number;
  imageUrl: string;
  addons?: Addon[];
}

export interface Category {
  id: string;
  name: string;
  products: Product[];
}

export interface CartItem {
  id: string; // Unique ID for the cart item instance
  product: Product;
  quantity: number;
  selectedAddons: Addon[];
}

export interface CarouselImage {
  id: string;
  description: string;
  imageUrl: string;
  imageHint: string;
}

export interface RestaurantInfo {
  name: string;
  logoUrl: string;
  footerText: string;
  minOrder: number;
  city: string;
  deliveryTime: string;
  whatsappNumber: string;
  webhookUrl?: string;
  facebookPixelHead?: string;
  facebookPixelBody?: string;
  googleTagManagerHead?: string;
  googleTagManagerBody?: string;
  googleAnalyticsHead?: string;
  googleAnalyticsBody?: string;
  mercadoPagoPublicKey?: string;
  carouselImages: CarouselImage[];
  colors: {
    primary: string;
    background: string;
    accent: string;
    foreground: string;
    card: string;
    cardForeground: string;
    mutedForeground: string;
  };
}

export interface OrderItem {
  productId: string;
  quantity: number;
  unitPrice: number;
  productName: string; // Denormalized for display
  addons: { name: string; price: number }[]; // Denormalized addons
}

export interface Order {
  id: string;
  customerName: string;
  deliveryAddress: string;
  paymentMethod: string;
  orderDate: Timestamp | Date;
  totalAmount: number;
  orderItems: OrderItem[];
}
